<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Método não permitido');
    }
    
    $host = trim($_POST['host'] ?? '');
    $dbname = trim($_POST['dbname'] ?? '');
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    // Validar dados
    if (empty($host) || empty($dbname) || empty($username)) {
        throw new Exception('Todos os campos são obrigatórios (exceto senha se em branco)');
    }
    
    // Testar conexão antes de salvar
    try {
        $pdo = new PDO(
            "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
            $username,
            $password,
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );
        
        // Teste simples
        $pdo->query("SELECT 1");
        
    } catch (PDOException $e) {
        throw new Exception('Erro de conexão: ' . $e->getMessage());
    }
    
    // Criar diretório config se não existir
    $configDir = '../config';
    if (!is_dir($configDir)) {
        if (!mkdir($configDir, 0755, true)) {
            throw new Exception('Erro ao criar diretório de configuração');
        }
    }
    
    // Preparar configuração
    $config = [
        'host' => $host,
        'dbname' => $dbname,
        'username' => $username,
        'password' => $password, // Em produção, considere criptografar
        'charset' => 'utf8mb4',
        'created_at' => date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s')
    ];
    
    // Salvar configuração
    $configFile = $configDir . '/database.json';
    if (file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT)) === false) {
        throw new Exception('Erro ao salvar arquivo de configuração');
    }
    
    // Proteger arquivo (apenas leitura para owner)
    chmod($configFile, 0600);
    
    echo json_encode([
        'success' => true,
        'message' => 'Configuração salva com sucesso'
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>