<?php
session_start();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Importação de Associados - WWASSE</title>
    <link rel="stylesheet" href="assets/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="container">
        <header class="header">
            <div class="logo">
                <i class="fas fa-users"></i>
                <h1>Sistema de Importação de Associados</h1>
            </div>
            <p class="subtitle">WWASSE - Gestão de Cadastros</p>
        </header>

        <main class="main">
            <!-- Status da Configuração -->
            <div class="card" id="config-status">
                <div class="card-header">
                    <i class="fas fa-cog"></i>
                    <h2>Status da Configuração</h2>
                </div>
                <div class="card-body">
                    <div class="status-item" id="db-status">
                        <i class="fas fa-database"></i>
                        <span>Conexão com Banco de Dados</span>
                        <div class="status-indicator" id="db-indicator">
                            <i class="fas fa-spinner fa-spin"></i>
                        </div>
                    </div>
                    <div class="status-item" id="tables-status">
                        <i class="fas fa-table"></i>
                        <span>Estrutura das Tabelas</span>
                        <div class="status-indicator" id="tables-indicator">
                            <i class="fas fa-spinner fa-spin"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Configuração do Banco -->
            <div class="card" id="config-card">
                <div class="card-header">
                    <i class="fas fa-wrench"></i>
                    <h2>Configuração do Banco de Dados</h2>
                    <button class="btn-toggle" onclick="toggleConfig()">
                        <i class="fas fa-chevron-down"></i>
                    </button>
                </div>
                <div class="card-body" id="config-form" style="display: none;">
                    <form id="db-config-form">
                        <div class="form-group">
                            <label for="host">Host do Banco:</label>
                            <input type="text" id="host" name="host" value="localhost" required>
                        </div>
                        <div class="form-group">
                            <label for="dbname">Nome do Banco:</label>
                            <input type="text" id="dbname" name="dbname" value="wwasse_cadastro" required>
                        </div>
                        <div class="form-group">
                            <label for="username">Usuário:</label>
                            <input type="text" id="username" name="username" required>
                        </div>
                        <div class="form-group">
                            <label for="password">Senha:</label>
                            <input type="password" id="password" name="password" required>
                        </div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i>
                            Salvar Configuração
                        </button>
                    </form>
                </div>
            </div>

            <!-- Upload de Arquivo -->
            <div class="card" id="upload-card">
                <div class="card-header">
                    <i class="fas fa-upload"></i>
                    <h2>Upload do Arquivo CSV</h2>
                </div>
                <div class="card-body">
                    <div class="upload-area" id="upload-area">
                        <div class="upload-content">
                            <i class="fas fa-cloud-upload-alt"></i>
                            <p>Arraste seu arquivo CSV aqui ou clique para selecionar</p>
                            <input type="file" id="csv-file" accept=".csv" style="display: none;">
                            <button class="btn btn-secondary" onclick="document.getElementById('csv-file').click()">
                                <i class="fas fa-folder-open"></i>
                                Selecionar Arquivo
                            </button>
                        </div>
                    </div>
                    <div class="file-info" id="file-info" style="display: none;">
                        <div class="file-details">
                            <i class="fas fa-file-csv"></i>
                            <div>
                                <span class="file-name" id="file-name"></span>
                                <span class="file-size" id="file-size"></span>
                            </div>
                            <button class="btn-remove" onclick="removeFile()">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                        <div class="file-preview" id="file-preview"></div>
                    </div>
                </div>
            </div>

            <!-- Controles de Importação -->
            <div class="card" id="import-card">
                <div class="card-header">
                    <i class="fas fa-play"></i>
                    <h2>Importação</h2>
                </div>
                <div class="card-body">
                    <div class="import-options">
                        <label class="checkbox-container">
                            <input type="checkbox" id="create-backup" checked>
                            <span class="checkmark"></span>
                            Criar backup antes da importação
                        </label>
                        <label class="checkbox-container">
                            <input type="checkbox" id="update-existing" checked>
                            <span class="checkmark"></span>
                            Atualizar registros existentes
                        </label>
                        <label class="checkbox-container">
                            <input type="checkbox" id="large-file-mode">
                            <span class="checkmark"></span>
                            Modo arquivo grande (10k+ registros)
                        </label>
                    </div>
                    
                    <div class="advanced-options" id="advanced-options" style="display: none;">
                        <h4><i class="fas fa-cog"></i> Configurações Avançadas</h4>
                        <div class="form-group">
                            <label for="batch-size">Tamanho do lote:</label>
                            <select id="batch-size">
                                <option value="25">25 registros (mais seguro)</option>
                                <option value="50" selected>50 registros (padrão)</option>
                                <option value="100">100 registros (mais rápido)</option>
                                <option value="200">200 registros (só para servidores potentes)</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="start-from">Iniciar da linha:</label>
                            <input type="number" id="start-from" value="0" min="0">
                            <small>Use para retomar importação interrompida</small>
                        </div>
                    </div>
                    
                    <button class="btn btn-success btn-large" id="start-import" onclick="startImport()" disabled>
                        <i class="fas fa-rocket"></i>
                        Iniciar Importação
                    </button>
                </div>
            </div>

            <!-- Progress Bar -->
            <div class="card" id="progress-card" style="display: none;">
                <div class="card-header">
                    <i class="fas fa-chart-line"></i>
                    <h2>Progresso da Importação</h2>
                </div>
                <div class="card-body">
                    <div class="progress-container">
                        <div class="progress-bar">
                            <div class="progress-fill" id="progress-fill"></div>
                        </div>
                        <div class="progress-text" id="progress-text">0%</div>
                    </div>
                    <div class="progress-stats">
                        <div class="stat-item">
                            <span class="stat-label">Processados:</span>
                            <span class="stat-value" id="stat-processed">0</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-label">Inseridos:</span>
                            <span class="stat-value" id="stat-inserted">0</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-label">Atualizados:</span>
                            <span class="stat-value" id="stat-updated">0</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-label">Erros:</span>
                            <span class="stat-value" id="stat-errors">0</span>
                        </div>
                    </div>
                    <div class="import-log" id="import-log"></div>
                </div>
            </div>

            <!-- Resultados -->
            <div class="card" id="results-card" style="display: none;">
                <div class="card-header">
                    <i class="fas fa-chart-bar"></i>
                    <h2>Resultados da Importação</h2>
                </div>
                <div class="card-body">
                    <div class="results-summary" id="results-summary"></div>
                    <div class="results-actions">
                        <button class="btn btn-info" onclick="showReport()">
                            <i class="fas fa-file-alt"></i>
                            Ver Relatório Completo
                        </button>
                        <button class="btn btn-primary" onclick="resetImport()">
                            <i class="fas fa-redo"></i>
                            Nova Importação
                        </button>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Modal para Relatório -->
    <div class="modal" id="report-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2>Relatório Detalhado</h2>
                <button class="modal-close" onclick="closeModal()">&times;</button>
            </div>
            <div class="modal-body" id="report-content">
                <!-- Conteúdo do relatório será carregado aqui -->
            </div>
        </div>
    </div>

    <script src="assets/script.js"></script>
    <script>
        // Verificar status ao carregar a página
        document.addEventListener('DOMContentLoaded', function() {
            checkDatabaseStatus();
            loadConfig();
        });
    </script>
</body>
</html>