<?php
/**
 * Script rápido para verificar exatamente quais colunas estão no seu CSV
 * Copie e cole este código em um arquivo verificar_colunas.php
 */

header('Content-Type: text/plain; charset=utf-8');

echo "=== VERIFICAÇÃO DAS COLUNAS DO CSV ===\n\n";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {
    $csvFile = $_FILES['csv_file']['tmp_name'];
    
    if (file_exists($csvFile)) {
        $handle = fopen($csvFile, 'r');
        
        // Detectar delimitador
        $sampleLine = fgets($handle);
        rewind($handle);
        
        $delimiter = ';'; // padrão detectado no seu log
        if (substr_count($sampleLine, ',') > substr_count($sampleLine, ';')) {
            $delimiter = ',';
        }
        
        echo "Delimitador detectado: '$delimiter'\n\n";
        
        // Ler cabeçalho
        $header = fgetcsv($handle, 0, $delimiter);
        
        if ($header) {
            echo "TOTAL DE COLUNAS: " . count($header) . "\n\n";
            echo "LISTA DAS COLUNAS:\n";
            echo "==================\n";
            
            foreach ($header as $i => $coluna) {
                $coluna = trim($coluna);
                echo sprintf("%2d. %-30s [%s]\n", 
                    $i + 1, 
                    $coluna, 
                    strtolower(str_replace([' ', 'ç', 'ã', 'õ', 'é', 'í', 'ó', 'ú', 'â', 'ê', 'î', 'ô', 'û', 'á'], 
                                         ['_', 'c', 'a', 'o', 'e', 'i', 'o', 'u', 'a', 'e', 'i', 'o', 'u', 'a'], $coluna))
                );
            }
            
            echo "\n\nPRIMEIRA LINHA DE DADOS:\n";
            echo "========================\n";
            
            $primeiraLinha = fgetcsv($handle, 0, $delimiter);
            if ($primeiraLinha) {
                foreach ($header as $i => $coluna) {
                    $valor = isset($primeiraLinha[$i]) ? trim($primeiraLinha[$i]) : '';
                    echo sprintf("%-30s = %s\n", $coluna, substr($valor, 0, 50) . (strlen($valor) > 50 ? '...' : ''));
                }
            }
            
            echo "\n\nMAPEAMENTO SUGERIDO:\n";
            echo "====================\n";
            
            $sugestoes = [
                'nome' => ['nome', 'name'],
                'cpf' => ['cpf'],
                'rg' => ['rg'],
                'email' => ['email', 'e-mail', 'e_mail'],
                'telefone' => ['telefone', 'fone', 'celular', 'fone_celular'],
                'endereco' => ['endereco', 'endereço', 'rua'],
                'cep' => ['cep'],
                'bairro' => ['bairro'],
                'cidade' => ['cidade'],
                'corporacao' => ['corporacao', 'corporação'],
                'patente' => ['patente'],
                'sexo' => ['sexo'],
                'nascimento' => ['nasc', 'nascimento', 'data_nasc']
            ];
            
            foreach ($sugestoes as $campoEsperado => $variantes) {
                foreach ($header as $i => $coluna) {
                    $colunaNorm = strtolower(trim($coluna));
                    foreach ($variantes as $variante) {
                        if (strpos($colunaNorm, $variante) !== false) {
                            echo "'$coluna' => '$campoEsperado',\n";
                            break 2;
                        }
                    }
                }
            }
            
        } else {
            echo "ERRO: Não foi possível ler o cabeçalho do arquivo\n";
        }
        
        fclose($handle);
        
    } else {
        echo "ERRO: Arquivo não encontrado\n";
    }
    
} else {
    echo "Envie seu arquivo CSV para verificar as colunas:\n\n";
    echo "<form method='post' enctype='multipart/form-data'>\n";
    echo "<input type='file' name='csv_file' accept='.csv' required><br><br>\n";
    echo "<button type='submit'>Verificar Colunas</button>\n";
    echo "</form>\n";
}
?>