<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

try {
    $configFile = '../config/database.json';
    
    if (!file_exists($configFile)) {
        echo json_encode([
            'success' => false,
            'message' => 'Configuração não encontrada'
        ]);
        exit;
    }
    
    $config = json_decode(file_get_contents($configFile), true);
    
    if (!$config) {
        echo json_encode([
            'success' => false,
            'message' => 'Erro ao ler configuração'
        ]);
        exit;
    }
    
    // Remover senha por segurança
    $configSafe = $config;
    unset($configSafe['password']);
    
    echo json_encode([
        'success' => true,
        'config' => $configSafe
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>