<?php
/**
 * Script para debugar e analisar a estrutura do CSV
 * Acesse: http://seusite.com/luis/db/debug_csv.php
 */

echo "<h1>🔍 Debug do Arquivo CSV</h1>";
echo "<style>
body{font-family:Arial;padding:20px;} 
.sample{background:#f8f9fa;padding:15px;border-radius:5px;margin:10px 0;border-left:4px solid #007bff;}
.error{color:red;} .success{color:green;} .warning{color:orange;}
table{border-collapse:collapse;width:100%;margin:20px 0;}
th,td{border:1px solid #ddd;padding:8px;text-align:left;}
th{background:#f2f2f2;}
</style>";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {
    $csvFile = $_FILES['csv_file']['tmp_name'];
    $fileName = $_FILES['csv_file']['name'];
    
    echo "<h2>📄 Analisando arquivo: $fileName</h2>";
    
    if (file_exists($csvFile)) {
        $fileSize = filesize($csvFile);
        echo "<p><strong>Tamanho:</strong> " . formatBytes($fileSize) . "</p>";
        
        // Abrir arquivo
        $handle = fopen($csvFile, 'r');
        if ($handle) {
            echo "<h3>🔎 Primeiras 20 linhas do arquivo:</h3>";
            echo "<div class='sample'>";
            
            $linhas = [];
            for ($i = 0; $i < 20; $i++) {
                $linha = fgets($handle);
                if ($linha === false) break;
                
                $linhas[] = trim($linha);
                echo "<strong>Linha " . ($i + 1) . ":</strong> " . htmlspecialchars(trim($linha)) . "<br>";
            }
            echo "</div>";
            
            // Análise da estrutura
            echo "<h3>📊 Análise da Estrutura:</h3>";
            
            // Detectar se é vertical ou horizontal
            $temVirgulas = 0;
            $temPontoVirgula = 0;
            $temTab = 0;
            
            foreach ($linhas as $linha) {
                if (strpos($linha, ',') !== false) $temVirgulas++;
                if (strpos($linha, ';') !== false) $temPontoVirgula++;
                if (strpos($linha, "\t") !== false) $temTab++;
            }
            
            echo "<table>";
            echo "<tr><th>Separador</th><th>Linhas com separador</th><th>Percentual</th></tr>";
            echo "<tr><td>Vírgula (,)</td><td>$temVirgulas</td><td>" . round(($temVirgulas/count($linhas))*100, 1) . "%</td></tr>";
            echo "<tr><td>Ponto-vírgula (;)</td><td>$temPontoVirgula</td><td>" . round(($temPontoVirgula/count($linhas))*100, 1) . "%</td></tr>";
            echo "<tr><td>Tab</td><td>$temTab</td><td>" . round(($temTab/count($linhas))*100, 1) . "%</td></tr>";
            echo "</table>";
            
            // Determinar formato
            if ($temVirgulas < 3 && $temPontoVirgula < 3 && $temTab < 3) {
                echo "<div class='success'>";
                echo "<h4>✅ FORMATO VERTICAL DETECTADO</h4>";
                echo "<p>Seus dados estão em formato vertical (um valor por linha).</p>";
                echo "<p><strong>Como processar:</strong></p>";
                echo "<ul>";
                echo "<li>Cada 26 linhas formam um registro completo</li>";
                echo "<li>Ordem esperada: nome, nascimento, sexo, rg, cpf, situação, etc.</li>";
                echo "<li>O sistema já está configurado para processar este formato</li>";
                echo "</ul>";
                echo "</div>";
                
                // Mostrar como ficaria agrupado
                echo "<h4>📋 Exemplo de como os dados serão agrupados:</h4>";
                echo "<div class='sample'>";
                
                $campos = [
                    'Nome', 'Nascimento', 'Sexo', 'RG', 'CPF', 'Situação', 'Escolaridade', 'Estado Civil',
                    'CEP', 'Endereço', 'Bairro', 'Cidade', 'Email', 'Fone Celular', 'Facebook',
                    'Instagram', 'Twitter', 'Corporação', 'Patente', 'Categoria', 'Lotação',
                    'Vínculo', 'Data Admissão', 'Telefone Comercial', 'Data Filiação', 'Data Desfiliação'
                ];
                
                echo "<table>";
                echo "<tr><th>Campo</th><th>Valor</th></tr>";
                for ($i = 0; $i < min(count($campos), count($linhas)); $i++) {
                    echo "<tr><td><strong>{$campos[$i]}</strong></td><td>" . htmlspecialchars($linhas[$i]) . "</td></tr>";
                }
                echo "</table>";
                echo "</div>";
                
            } else {
                echo "<div class='warning'>";
                echo "<h4>⚠️ FORMATO HORIZONTAL DETECTADO</h4>";
                echo "<p>Seus dados parecem estar em formato CSV tradicional.</p>";
                echo "</div>";
                
                // Tentar detectar separador
                $separador = ',';
                if ($temPontoVirgula > $temVirgulas) $separador = ';';
                if ($temTab > $temVirgulas && $temTab > $temPontoVirgula) $separador = "\t";
                
                echo "<p><strong>Separador detectado:</strong> " . ($separador === "\t" ? 'TAB' : $separador) . "</p>";
                
                // Mostrar colunas
                rewind($handle);
                $primeiraLinha = fgetcsv($handle, 0, $separador);
                if ($primeiraLinha) {
                    echo "<h4>📋 Colunas encontradas:</h4>";
                    echo "<div class='sample'>";
                    echo "<ol>";
                    foreach ($primeiraLinha as $coluna) {
                        echo "<li>" . htmlspecialchars(trim($coluna)) . "</li>";
                    }
                    echo "</ol>";
                    echo "</div>";
                }
            }
            
            // Contar total de linhas
            rewind($handle);
            $totalLinhas = 0;
            while (fgets($handle) !== false) {
                $totalLinhas++;
            }
            
            echo "<h4>📈 Estatísticas do Arquivo:</h4>";
            echo "<table>";
            echo "<tr><td><strong>Total de linhas</strong></td><td>$totalLinhas</td></tr>";
            
            if ($temVirgulas < 3 && $temPontoVirgula < 3 && $temTab < 3) {
                $registrosEstimados = floor($totalLinhas / 26);
                echo "<tr><td><strong>Registros estimados</strong></td><td>$registrosEstimados</td></tr>";
                echo "<tr><td><strong>Campos por registro</strong></td><td>26</td></tr>";
            }
            
            echo "</table>";
            
            fclose($handle);
        } else {
            echo "<p class='error'>❌ Erro ao abrir arquivo</p>";
        }
    } else {
        echo "<p class='error'>❌ Arquivo não encontrado</p>";
    }
    
} else {
    echo "<h2>📤 Envie seu arquivo CSV para análise</h2>";
    echo "<form method='post' enctype='multipart/form-data'>";
    echo "<p><input type='file' name='csv_file' accept='.csv' required></p>";
    echo "<p><button type='submit'>🔍 Analisar Arquivo</button></p>";
    echo "</form>";
    
    echo "<div class='sample'>";
    echo "<h3>ℹ️ O que este script faz:</h3>";
    echo "<ul>";
    echo "<li>Analisa a estrutura do seu arquivo CSV</li>";
    echo "<li>Detecta se é formato vertical ou horizontal</li>";
    echo "<li>Mostra as primeiras 20 linhas</li>";
    echo "<li>Identifica separadores</li>";
    echo "<li>Estima quantos registros serão importados</li>";
    echo "<li>Mostra como os dados serão processados</li>";
    echo "</ul>";
    echo "</div>";
}

function formatBytes($size, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB');
    for ($i = 0; $size > 1024 && $i < count($units) - 1; $i++) {
        $size /= 1024;
    }
    return round($size, $precision) . ' ' . $units[$i];
}
?>